<?php

namespace App\Http\Controllers\Application;

use App\Http\Controllers\Controller;
use App\Models\Application\Post\Post;
use App\Models\Application\User\Team;
use App\Models\Core\Auth\User;
use App\Repositories\Core\Status\StatusRepository;
use Illuminate\Support\Facades\DB;

class SelectableController extends Controller
{

    public function relatedUsers(User $user): \Illuminate\Database\Eloquent\Collection|array
    {

        $status = resolve(StatusRepository::class)->userActive();
        $userQuery = User::query()->select('id' , 'first_name', 'last_name', 'uuid')
            ->with('profilePicture:path,fileable_type,fileable_id');

        $userQuery
            ->where('status_id', $status)
            ->where('id', '!=', auth()->id());

        if(!auth()->user()->isAdmin()) {
            $userQuery->whereHas('roles', function ($qTeam) use ($user){
                // admin role.
                $qTeam->where('role_id', 1);
            })
            ->where('status_id', $status)
            ->where('id', '!=', auth()->id());
        }

        return $userQuery
            ->get();
    }

}
