<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Exceptions\GeneralException;
use App\Http\Controllers\Controller;
use App\Http\Requests\AiRequest;
use Gainhq\Installer\App\Services\DeliverySettingService;

class AiSettingController extends Controller
{
    public function __construct(DeliverySettingService $setting)
    {
        $this->service = $setting;
    }

    public function index()
    {
        $openai = resolve(DeliverySettingService::class)->getFormattedDeliverySettings('open_ai');

        if(env('MARKET_PLACE_VERSION', false)) {
            if(isset($openai['open_ai_key'])) {
                $openai['open_ai_key'] = '**********************************************';
            }
        }

        return $openai;
    }

    public function update(AiRequest $request)
    {
        throw_if(env('MARKET_PLACE_VERSION', false), new GeneralException(__t('not_available_in_demo')));
        $validated = $request->validated();
        foreach ($validated as $key => $value) {
            $this->service
                ->update($key, $value, 'open_ai');
        }
        return updated_responses('open_ai_settings');


    }
}
