<?php

namespace App\Http\Controllers\Admin\Navigation;

use App\Exceptions\GeneralException;
use App\Http\Controllers\Controller;
use App\Models\Application\Post\Post;
use App\Models\Application\User\Team;
use App\Models\Core\Auth\User;
use App\Repositories\Core\Status\StatusRepository;

class NavigationController extends Controller
{
    public function myProfile()
    {
        return view('admin.profile.index');
    }

    public function exampleTable()
    {
        return view('admin.example.table');
    }

    public function viewUserAndRole()
    {
        if (!authorize_any(
            ['view_users', 'view_roles', 'invite_user', 'create_roles']
        )) {
            throw new GeneralException(trans('default.action_not_allowed'));
        }
        return view('admin.user_and_role.index');
    }

    public function appSetting()
    {
        if (!authorize_any(
            [
                'view_settings',
                'update_settings',
                'view_delivery_settings',
                'update_delivery_settings',
                'view_notification_settings',
                'update_notification_settings',
                'update_notification_templates',
                'view_notification_templates',
                'view_ai_settings',
                'update_ai_settings',
            ]
        )) {
            throw new GeneralException(trans('default.action_not_allowed'));
        }
        return view('admin.setting.index', ['permissions' => [
            'general' => authorize_any(['view_settings', 'update_settings']),
            'email_settings' => authorize_any(['view_delivery_settings', 'update_delivery_settings']),
            'sms_settings' => authorize_any(['view_sms_settings', 'update_sms_settings']),
            'recaptcha_settings' => authorize_any(['view_recaptcha_settings', 'update_recaptcha_settings']),
            'ai_settings' => authorize_any(['view_ai_settings', 'update_ai_settings']),
            'notification' => authorize_any(['view_notification_settings', 'update_notification_settings', 'view_notification_templates', 'update_notification_templates']),
        ]]);
    }

    public function notificationList()
    {
        return view('admin.notification.index');
    }
}
