<?php

namespace App\Http\Controllers\Admin\AI;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AI\FavoriteRequest;
use App\Facades\FavoriteTemplateFacade;
use App\Facades\JsonResponse;
use App\Facades\TemplateFacade;
use Illuminate\Http\Request;

class TemplateController extends Controller
{
    public function list()
    {
        try {
            return JsonResponse::withData(TemplateFacade::index());
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function generatorForm($templateSlug)
    {
        try {
            $template = TemplateFacade::findBySlug($templateSlug);
            return view('admin.template.generator_form', [
                'template' => $template,
            ]);
        } catch (\Exception $e) {
            return redirect()->back();
        }
    }

    public function generatorData()
    {
        try {
            return JsonResponse::withData(TemplateFacade::generatorData());
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }
    public function getFavorite()
    {
        try {
            return JsonResponse::withData(FavoriteTemplateFacade::index());
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function addFavorite(FavoriteRequest $request)
    {
        try {
            $response = FavoriteTemplateFacade::store($request->all());
            return JsonResponse::withData(FavoriteTemplateFacade::index(), $response);
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }
}
