<?php

namespace App\Http\Controllers\Admin\AI;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AI\DocumentRequest;
use App\Facades\DocumentFacade;
use App\Facades\JsonResponse;
use App\Http\Requests\Admin\AI\DocumentUpdateRequest;
use Illuminate\Http\Request;

class DocumentController extends Controller
{
    public function list()
    {
        try {
            return DocumentFacade::index();
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function store(DocumentRequest $request)
    {
        try {
            DocumentFacade::store($request->only(['category_id', 'content', 'name']));
            return JsonResponse::created(trans('default.created_response', ['name' => 'Document']));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function update(DocumentUpdateRequest $request)
    {
        try {
            DocumentFacade::update($request->document_id, $request->only(['category_id', 'content', 'name']));
            return JsonResponse::success(trans('default.updated_response', ['name' => 'Document']));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function find($document_id)
    {
        try {
            return JsonResponse::withData(DocumentFacade::find($document_id));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function destroy($document_id)
    {
        try {
            DocumentFacade::destroy($document_id);
            return JsonResponse::success(trans('default.deleted_response', ['name' => 'Document']));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }
}
