<?php

namespace App\Http\Controllers\Admin\AI;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AI\CompletionRequest;
use App\Facades\CompletionFacade;
use App\Facades\JsonResponse;
use Illuminate\Http\Request;

class CompletionController extends Controller
{

    public function generate(CompletionRequest $request)
    {
        try {
            $response = CompletionFacade::generate($request->all());
            return JsonResponse::withData($response->choices, __t('content_generated'));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function summary(){
        try {
            return JsonResponse::withData(CompletionFacade::summary());
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }

    public function checkDailyLimit(){
        try {
            return JsonResponse::withData(CompletionFacade::checkDailyLimit());
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }
}
