<?php

namespace App\Http\Controllers\Admin\AI;

use App\Facades\CategoryFacade;
use App\Facades\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function list()
    {
        try {
            return JsonResponse::withData(CategoryFacade::getByType(request()->get('type', 'template')));
        } catch (\Exception $e) {
            return JsonResponse::internalError($e->getMessage());
        }
    }
}
