<?php

namespace App\Http\Composer;

use App\Http\Composer\Helper\AdministrationPermissions;
use Illuminate\View\View;

class SidebarComposer
{
    public function compose(View $view)
    {

        $menu = [
            [
                'url' => route('core.dashboard'),
                'icon' => 'pie-chart',
                'name' => __t('dashboard'),
                'permission' => authorize_any(['manage_dashboard']),
            ],
            [
                'url' => route('template.index'),
                'icon' => 'file-text',
                'name' => __t('templates'),
                'permission' => authorize_any(['manage_dashboard']),
            ],
           [
               'url' => route('document.index'),
               'icon' => 'folder',
               'name' => __t('documents'),
               'permission' => authorize_any(['manage_dashboard']),
           ],
            [
                'url' => route('my-profile.view'),
                'icon' => 'user',
                'name' => __t('my_profile'),
                'permission' => true,
            ],
            [
                'url' => route('user-and-role.view'),
                'icon' => 'briefcase',
                'name' => __t('user_and_roles'),
                'permission' => authorize_any(['view_users', 'view_roles', 'invite_user', 'create_roles']),
            ],
            [
                'icon' => 'settings',
                'name' => __t('settings'),
                'url' => request()->root() . '/app-setting',
                'permission' => authorize_any(
                    [
                        'view_settings',
                        'update_settings',
                        'view_delivery_settings',
                        'update_delivery_settings',
                        'view_notification_settings',
                        'update_notification_settings',
                        'update_notification_templates',
                        'view_notification_templates',
                        'view_ai_settings',
                        'update_ai_settings',
                    ]
                ),
            ],
        ];


        $view->with(['data' => $menu]);
    }
}
