<?php

namespace App\Http\Composer;

use Illuminate\View\View;
class NavbarComposer
{
    public function compose(View $view)
    {
        $top_bar_menu = [
            [
                'optionName' => __t('my_profile'),
                'optionIcon' => 'user',
                'url' => route('my-profile.view')
            ],
            [
                'optionName' => __t('notifications'),
                'optionIcon' => 'bell',
                'url' => route("notification.view")
            ],
            [
                'optionName' => __t('logout'),
                'optionIcon' => 'log-out',
                'url' => route("auth.log_out")
            ],
        ];

        $view->with([
            'top_bar_menu' => $top_bar_menu,
        ]);
    }
}
