<?php

namespace App\Http\Composer\Helper;

use App\Helpers\Core\Traits\InstanceCreator;

class AdministrationPermissions
{
    use InstanceCreator;

    public function subMenu()
    {
        return [
            [
                'name' => __t('user_and_roles'),
                'url' => route(
                    'user-and-role.view'
                ),
                'permission' => authorize_any(['view_users', 'view_roles', 'invite_user', 'create_roles'])
            ],
        ];
    }

    public function canVisit()
    {
        return authorize_any(['view_users', 'view_roles', 'invite_user', 'create_roles']);
    }
}
