<?php

namespace App\Helpers\Config;

use App\Helpers\Core\Traits\InstanceCreator;
use App\Services\Core\Setting\DeliverySettingService;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;

class SetAiConfig
{
    use InstanceCreator;

    public function cacheClear()
    {
        Artisan::call('config:clear');
        return $this;
    }

    public function configSet()
    {
        $openai = resolve(DeliverySettingService::class)->getFormattedDeliverySettings('open_ai');

        if ($openai && isset($openai['open_ai_key'])) {
            Config::set('openai.api_key', $openai['open_ai_key']);
            return;
        }

        Config::set('openai.api_key', env('OPENAI_API_KEY'));
    }
}
