<?php

namespace App\Filters\Example;

use App\Filters\Traits\DateRangeFilter;
use App\Filters\Core\traits\NameFilter;
use App\Filters\Core\traits\SearchFilterTrait;
use App\Filters\FilterBuilder;
use App\Filters\Traits\StatusFilterTrait;
use Illuminate\Database\Eloquent\Builder;

class ExampleTableFilter extends FilterBuilder
{
    use SearchFilterTrait, NameFilter, DateRangeFilter, StatusFilterTrait;

    public function ageRange($age = null)
    {
        $age = json_decode(htmlspecialchars_decode($age), true);
        $this->builder->when($age, function (Builder $builder) use ($age) {
            $builder->whereBetween('age', array_values($age));
        });
    }

    public function filterWithGender($gender = null)
    {
        $this->whereClause('gender', $gender);
    }


}