<?php

namespace App\Filters\Application\Dashboard;

use App\Filters\FilterBuilder;
use Illuminate\Support\Carbon;

class DashboardOverviewFilter extends FilterBuilder
{
    public function lastSevenDays()
    {
        return $this->builder
            ->where('created_at', '>', Carbon::now()->subDays(7)
            ->format('Y-m-d'));
    }

    public function thisWeek()
    {
        return $this->builder->whereBetween('created_at',
            [
                Carbon::now()->startOfWeek(Carbon::SUNDAY)->format('Y-m-d'),
                Carbon::now()->endOfWeek(Carbon::SATURDAY)->format('Y-m-d')
            ]);
    }

    public function lastWeek()
    {
        return $this->builder->whereBetween('created_at',
            [
                Carbon::now()->subWeek()->startOfWeek(Carbon::SUNDAY)->format('Y-m-d'),
                Carbon::now()->subWeek()->endOfWeek(Carbon::SATURDAY)->format('Y-m-d')
            ]);
    }

    public function thisMonth()
    {
        return $this->builder->whereBetween('created_at',
            [
                Carbon::now()->startOfMonth()->format('Y-m-d'),
                Carbon::now()->endOfMonth()->format('Y-m-d')
            ]);
    }

    public function lastMonth()
    {
        return $this->builder->whereBetween('created_at',
            [
                Carbon::now()->startOfMonth()->subMonth()->format('Y-m-d'),
                Carbon::now()->subMonthNoOverflow()->endOfMonth()->format('Y-m-d')
            ]);
    }

    public function thisYear()
    {
        return $this->builder->whereBetween('created_at',
            [
                Carbon::now()->startOfYear()->format('Y-m-d'),
                Carbon::now()->endOfYear()->format('Y-m-d')
            ]);
    }
}
