<?php

namespace App\Filters\Application\AI;

use App\Filters\FilterBuilder;
use App\Filters\Traits\CategoryFilterTrait;
use App\Filters\Traits\DateRangeFilter;
use Illuminate\Database\Eloquent\Builder;

class DocumentFilter extends FilterBuilder
{
    use DateRangeFilter, CategoryFilterTrait;
    public function search($search = null)
    {
        $this->builder->when($search, function (Builder $builder) use ($search) {
            $builder->where('documents.name', 'LIKE', "%$search%")
            ->orWhereHas('category', function ($query) use ($search) {
                $query->where('categories.name', 'LIKE', "%$search%");
            });
        });
    }
}
