<?php

namespace App\Events;

use App\Models\Core\Auth\User;
use Illuminate\Notifications\DatabaseNotification;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Broadcasting\PrivateChannel;

class NewNotification implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * User that sent the message.
     *
     * @var User
     */
    public $receiver;

    /**
     * Message details.
     *
     * @var Message
     */
    public $message;
    public $notifications;


    /**
     * Create a new event instance.
     */
    public function __construct($receiver, $message)
    {
        $this->receiver = $receiver;
        $this->message = $message;
        $this->notifications = $this->getNotifications();
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return [
            new PrivateChannel('user_notifications.'.$this->receiver)
        ];
    }
    public function getNotifications() {
        return DatabaseNotification::where('notifiable_type', User::class)
                            ->where('notifiable_id', $this->receiver)
                            ->whereNull( 'read_at' )
                            ->paginate(4);
    }
}
